//
//  ViewModifiers.swift
//  Do It
//
//  Created by Jim Dovey on 2/4/20.
//  Copyright © 2020 Jim Dovey. All rights reserved.
//

import SwiftUI

// START:ModifierImpl
struct DoubleShadow: ViewModifier {
    var radius: CGFloat = 10.0 // <label id="code.ch5.modifier.shadow.radius" />
    func body(content: Content) -> some View {
        content
            .shadow(color: Color.black.opacity(0.1), // <label id="code.ch5.modifier.shadow.soft" />
                    radius: radius, x: 0, y: radius * 1.2)
            .shadow(color: Color.black.opacity(0.2), // <label id="code.ch5.modifier.shadow.narrow" />
                    radius: max(radius/10, 1), x: 0, y: 1)
    }
}
// END:ModifierImpl

// START:BorderedImpl
struct BorderedTextField: ViewModifier {
    func body(content: Content) -> some View {
        content
            .multilineTextAlignment(.center) // <label id="code.ch5.modifier.text-alignment" />
            .padding(.vertical, 12)
            .background(
                RoundedRectangle(cornerRadius: 10, style: .continuous) // <label id="code.ch5.rounded.continuous" />
                    .foregroundColor(Color(UIColor.tertiarySystemFill)) // <label id="code.ch5.modifier.tertiary.fill" />
            )
    }
}
// END:BorderedImpl

struct ViewModifiers_Previews: PreviewProvider {
    // START:BorderPreviews
    static var _sampleText: String = "Sample Text"
    static var sampleText: Binding<String> = Binding(
        get: { _sampleText }, set: { _sampleText = $0 })

    static var previews: some View {
        // START:ShadowPreviews
        Group {
            // END:ShadowPreviews
            // <literal:elide> shadow previews </literal:elide>
            // START:ShadowPreviews
            // END:BorderPreviews
            Circle()
                .frame(width: 300, height: 300)
                .foregroundColor(.white)
                .modifier(DoubleShadow())

            Circle()
                .frame(width: 300, height: 300)
                .foregroundColor(.white)
                .modifier(DoubleShadow(radius: 20))

            Circle()
                .frame(width: 300, height: 300)
                .foregroundColor(.white)
                .modifier(DoubleShadow(radius: 6))
            // END:ModifierPreviews

            // START:BorderPreviews
            Text("Start Making Things")
                .padding(.horizontal)
                .modifier(BorderedTextField())

            TextField("Title", text: sampleText)
                .modifier(BorderedTextField())
        }
        .previewLayout(.fixed(width: 350, height: 350))
        // END:ShadowPreviews
    }
    // END:BorderPreviews
}
